/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.structures.jisaw;

import com.github.L_Ender.cataclysm.init.ModStructures;
import com.github.L_Ender.cataclysm.structures.jisaw.CataclysmJigsawManager;
import com.github.L_Ender.cataclysm.world.structures.terrainadaptation.EnhancedTerrainAdaptation;
import com.github.L_Ender.cataclysm.world.structures.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.jetbrains.annotations.NotNull;

public class CataclysmJigsawStructure
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 192;
    public static final MapCodec<CataclysmJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CataclysmJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)192).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DimensionPadding.ZERO).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.APPLY_WATERLOGGING).forGetter(structure -> structure.liquidSettings)).apply((Applicative)builder, CataclysmJigsawStructure::new)).validate(CataclysmJigsawStructure::validateRange);
    public final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    public final int maxDepth;
    public final HeightProvider startHeight;
    public final IntProvider xOffsetInChunk;
    public final IntProvider zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public CataclysmJigsawStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, IntProvider xOffsetInChunk, IntProvider zOffsetInChunk, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(structureSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    private static DataResult<CataclysmJigsawStructure> validateRange(CataclysmJigsawStructure structure) {
        int vanillaEdgeBuffer;
        if (structure.terrainAdaptation() != TerrainAdjustment.NONE && structure.enhancedTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
            return DataResult.error(() -> "Cataclysm Structure cannot use both vanilla terrain_adaptation and enhanced_terrain_adaptation");
        }
        switch (structure.terrainAdaptation()) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                int n = 0;
                break;
            }
            case BURY: 
            case BEARD_THIN: 
            case BEARD_BOX: 
            case ENCAPSULATE: {
                int n = vanillaEdgeBuffer = 12;
            }
        }
        if (structure.maxDistanceFromCenter + vanillaEdgeBuffer > 192) {
            return DataResult.error(() -> "Cataclysm Structure's max_distance_from_center must not exceed 116 when using vanilla terrain_adaptation");
        }
        int enhancedEdgeBuffer = structure.enhancedTerrainAdaptation.getKernelRadius();
        if (structure.maxDistanceFromCenter + enhancedEdgeBuffer > 192) {
            return DataResult.error(() -> "Cataclysm Structure's max_distance_from_center + kernel radius (equal to half the enhanced_terrain_adaptation's kernel size) must not exceed 128");
        }
        return DataResult.success((Object)((Object)structure));
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom randomSource = context.random();
        int xOffset = this.xOffsetInChunk.sample((RandomSource)randomSource);
        int zOffset = this.zOffsetInChunk.sample((RandomSource)randomSource);
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos startPos = new BlockPos(chunkPos.getBlockX(xOffset), startY, chunkPos.getBlockZ(zOffset));
        return CataclysmJigsawManager.assembleJigsawStructure(context, this.startPool, this.startJigsawName, this.maxDepth, startPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.maxY, this.minY, this.dimensionPadding, this.liquidSettings);
    }

    @NotNull
    public BoundingBox adjustBoundingBox(@NotNull BoundingBox boundingBox) {
        return super.adjustBoundingBox(boundingBox).inflatedBy(this.enhancedTerrainAdaptation.getKernelRadius());
    }

    @NotNull
    public StructureType<?> type() {
        return (StructureType)ModStructures.CATACLYSM_JIGSAW.get();
    }
}

